﻿using System.Windows;

namespace Microscopic_Traffic_Simulator.Views.SettingsView
{
    /// <summary>
    /// Interaction logic for SettingsWindow.xaml
    /// </summary>
    public partial class ParametersWindow : Window
    {
        /// <summary>
        /// Parameters window constructor.
        /// </summary>
        public ParametersWindow()
        {
            InitializeComponent();            
        }

        /// <summary>
        /// Event after pressing cancel button. The window is closed without any result.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Not used event args.</param>
        private void ButtonCancel_Click(object sender, RoutedEventArgs e)
        {            
            Close();
        }

        /// <summary>
        /// Event after pressing OK button. The window is closed with positive result.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Unused event args.</param>
        private void OK_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = true;
            Close();
        }
    }
}
